function [cllr_logReg_plain] = calibration_validation(plda_scores,lab_test,gun_testPair_all,folder_to_store,flag,fig_title)
%% input
% plda_scores
% lab_test : same source:1, different source:0, labels for each plda score
%            in the test set
% gun_testPair_all : gun numbers for all pairs of same and different source
%                    test cartridge cases
% folder_to_store :  folder to store all outputs- figures + cllr values
% flag : decides whether to plot tippett or not- takes value 1 or 0
%        respectively
% fig_title : title of the figure
%% output
% cllr_logReg_plain : cllr values calculated using regularized logistic
%                     regression
% tippett plot is drawn and saved to folder_to_store if flag value is set
%                     to 1


II_s=false(size(lab_test));
II_s(lab_test==1)=true;
II_d = ~II_s;

% unique_guns = unique(Gun_testPair_all(:,1));
% num_guns = length(unique_guns);

AA=sort(gun_testPair_all,2);
[GroupId,~,index_j]=unique(AA(:,1));
T2=arrayfun(@(y)  unique(AA(find_logical(index_j==y),2)),1:length(GroupId),'UniformOutput',false);


logLR_LogReg_plain=[];LogLR=[];Outp=[];
%test_pairs_done = false(num_test_pairs,1);
test_indices=[];

parfor (I_test_pairs =1: size(GroupId,1),29)
    gun_q = GroupId(I_test_pairs, 1);
    for j=1:size(T2{1,I_test_pairs},1)
        gun_k = T2{1,I_test_pairs}(j,1)
        
        % hold out all scores associated with either member of the pair of speakers whose scores are being calibrated
        
        II_held_out = (gun_testPair_all(:,1) == gun_k) | (gun_testPair_all(:,1) == gun_q) | (gun_testPair_all(:,2) == gun_k) | (gun_testPair_all(:,2) == gun_q);
        
        % use remaining scores to train models
        scores_for_train = plda_scores(~II_held_out,:);
        II_s_for_train = II_s(~II_held_out);
        II_d_for_train = II_d(~II_held_out);
        num_gun_train = length(unique(gun_testPair_all(~II_held_out, 1)));

        % test all pairs of cartridges from both members of this pair of Guns (Gun A v Gun B and Gun B v Gun A)
        II_test_pair = ((gun_testPair_all(:,1) == gun_q) & (gun_testPair_all(:,2) == gun_k)) | ((gun_testPair_all(:,1) == gun_k) & (gun_testPair_all(:,2) == gun_q));
        NN_test_pair = find_logical(II_test_pair);
        scores_to_test = plda_scores(NN_test_pair,:);

       % w = train_llr_fusion(scores_for_train(II_s_for_train,:)', scores_for_train(II_d_for_train,:)',0.5);
        w = train_llr_fusion_regularized(scores_for_train(II_s_for_train,:)',scores_for_train(II_d_for_train,:)', 0.5, 1,num_gun_train);
        logLR_LogReg_plain = lin_fusion(w,scores_to_test');
        
        LogLR=[LogLR; logLR_LogReg_plain'];
        Outp=[Outp;lab_test(NN_test_pair)];
        %LR_logReg(I_test_pairs)=exp(ab);
        test_indices=[test_indices; NN_test_pair];
    end
end
LR=exp(LogLR);
cllr_logReg_plain = cllr_calc(LR,Outp,1);
if flag==1
    figure;
    fname=cat(2,fig_title,'.fig');
    full_fileName=fullfile(folder_to_store,fname);
    plot_tippett(LR(Outp==1),[],LR(Outp==0),[]);
    title(fig_title);
    savefig(full_fileName);
end
end

